/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleEvent;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleListener;
import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;

public final class HMCTimer {
    private static final String TRACE_MASKT = "XH-TIMET";
    private static final String TRACE_MASKF = "XH-TIMEF";
    private static final String TRACE_MASKD = "XH-TIMED";
    private static HMCTimer theSingleTimer = null;
    private String name = null;
    private boolean terminate = false;
    private HMCTaskQueue queue = new HMCTaskQueue();

    public static synchronized HMCTimer getHMCTimer() {
        if (theSingleTimer == null) {
            theSingleTimer = new HMCTimer("Common HMC-Timer");
        }
        return theSingleTimer;
    }

    private HMCTimer(String name) {
        this.name = name;
        HMCTimerThread timerThread = new HMCTimerThread(name);
        timerThread.setDaemon(true);
        timerThread.start();
        TimeManager.getTimeManager().addTimeChangedOnConsoleListener(this.queue);
    }

    protected void finalize() {
        this.terminate();
    }

    private ProxiedTimerTask formProxy(HMCTimerTask task, long start, long period, boolean fixedDelay) {
        ProxiedTimerTask pTask = task.isLongRunning() ? new LongRunningProxiedTimerTask(task) : new ShortRunningProxiedTimerTask(task);
        pTask.nextExecutionTime = start;
        pTask.period = period;
        pTask.fixedDelay = fixedDelay;
        return pTask;
    }

    private ProxiedTimerTask formProxy(HMCTimerTask task, long start) {
        return this.formProxy(task, start, 0L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTask(ProxiedTimerTask task) {
        HMCTaskQueue hMCTaskQueue = this.queue;
        synchronized (hMCTaskQueue) {
            this.queue.add(task);
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        HMCTaskQueue hMCTaskQueue = this.queue;
        synchronized (hMCTaskQueue) {
            this.terminate = true;
            this.queue.notifyAll();
        }
    }

    public void schedule(HMCTimerTask task, long delay) {
        Trace.trace(TRACE_MASKF, "schedule(" + task + ", " + delay + ")");
        this.scheduleTask(this.formProxy(task, System.currentTimeMillis()));
    }

    public void schedule(HMCTimerTask task, Date time) {
        Trace.trace(TRACE_MASKF, "schedule(" + task + ", " + time + ")");
        this.scheduleTask(this.formProxy(task, time.getTime()));
    }

    public void schedule(HMCTimerTask task, long delay, long period) {
        Trace.trace(TRACE_MASKF, "schedule(" + task + ", " + delay + ", " + period + ")");
        this.scheduleTask(this.formProxy(task, System.currentTimeMillis() + delay, delay, true));
    }

    public void schedule(HMCTimerTask task, Date firstTime, long period) {
        Trace.trace(TRACE_MASKF, "schedule(" + task + ", " + firstTime + ", " + period + ")");
        this.scheduleTask(this.formProxy(task, firstTime.getTime(), period, true));
    }

    public void scheduleAtFixedRate(HMCTimerTask task, long delay, long period) {
        Trace.trace(TRACE_MASKF, "scheduleAtFixedRate(" + task + ", " + delay + ", " + period + ")");
        this.scheduleTask(this.formProxy(task, System.currentTimeMillis() + delay, period, false));
    }

    public void scheduleAtFixedRate(HMCTimerTask task, Date firstTime, long period) {
        Trace.trace(TRACE_MASKF, "scheduleAtFixedRate(" + task + ", " + firstTime + ", " + period + ")");
        this.scheduleTask(this.formProxy(task, firstTime.getTime(), period, false));
    }

    class HMCTimerThread
    extends Thread {
        HMCTimerThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer service thread ('" + Thread.currentThread().getName() + "') begins running.");
            while (!HMCTimer.this.terminate) {
                ProxiedTimerTask pTask = null;
                boolean runTask = false;
                try {
                    HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
                    synchronized (hMCTaskQueue) {
                        while (HMCTimer.this.queue.isEmpty() && !HMCTimer.this.terminate) {
                            HMCTimer.this.queue.wait();
                        }
                        if (!HMCTimer.this.terminate) {
                            pTask = HMCTimer.this.queue.next();
                            if (pTask.canceled) {
                                HMCTimer.this.queue.remove();
                            } else {
                                long currentTime = System.currentTimeMillis();
                                boolean bl = runTask = pTask.nextExecutionTime <= currentTime;
                                if (runTask) {
                                    if (pTask.period == 0L) {
                                        HMCTimer.this.queue.remove();
                                    } else {
                                        HMCTimer.this.queue.reschedule(pTask.reschedule(currentTime));
                                    }
                                } else {
                                    HMCTimer.this.queue.wait(pTask.nextExecutionTime - currentTime);
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!runTask) continue;
                pTask.run();
            }
            Trace.trace(HMCTimer.TRACE_MASKF, "HMC-Timer service thread ('" + Thread.currentThread().getName() + "') ends.");
        }
    }

    static class HMCTaskQueue
    implements TimeChangedOnConsoleListener {
        private ProxiedTimerTask[] queue = new ProxiedTimerTask[128];
        private int size = 0;

        HMCTaskQueue() {
        }

        void add(ProxiedTimerTask task) {
            if (++this.size == this.queue.length) {
                ProxiedTimerTask[] newQueue = new ProxiedTimerTask[2 * this.queue.length];
                System.arraycopy(this.queue, 0, newQueue, 0, this.size);
                this.queue = newQueue;
            }
            this.queue[this.size] = task;
            this.fixUp(this.size);
        }

        ProxiedTimerTask next() {
            return this.queue[1];
        }

        void remove() {
            this.queue[1] = this.queue[this.size];
            this.queue[this.size--] = null;
            this.fixDown(1);
        }

        void reschedule(long newTime) {
            this.queue[1].nextExecutionTime = newTime;
            this.fixDown(1);
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        void clear() {
            for (int i = 1; i <= this.size; ++i) {
                this.queue[i] = null;
            }
            this.size = 0;
        }

        public synchronized void timeChangedOnConsole(TimeChangedOnConsoleEvent event) {
            ProxiedTimerTask[] oldQueue = this.queue;
            this.queue = new ProxiedTimerTask[this.queue.length];
            for (int i = 1; i <= this.size; ++i) {
                oldQueue[i].timeChanged(event);
                this.add(oldQueue[i]);
            }
        }

        private void fixUp(int k) {
            while (k > 1) {
                int j = k >> 1;
                if (this.queue[j].nextExecutionTime <= this.queue[k].nextExecutionTime) break;
                ProxiedTimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
            }
        }

        private void fixDown(int k) {
            int j;
            while ((j = k << 1) <= this.size) {
                if (j < this.size && this.queue[j].nextExecutionTime > this.queue[j + 1].nextExecutionTime) {
                    ++j;
                }
                if (this.queue[k].nextExecutionTime <= this.queue[j].nextExecutionTime) break;
                ProxiedTimerTask tmp = this.queue[j];
                this.queue[j] = this.queue[k];
                this.queue[k] = tmp;
                k = j;
            }
        }
    }

    class ShortRunningProxiedTimerTask
    extends ProxiedTimerTask {
        ShortRunningProxiedTimerTask(HMCTimerTask task) {
            super(task);
        }

        public void run() {
            try {
                this.task.run();
            }
            catch (Throwable e) {
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                Trace.trace(HMCTimer.TRACE_MASKF, "Throwable (" + e + ") from short run task (" + this.task + ") consumed by " + HMCTimer.this.name + ".");
            }
        }
    }

    class LongRunningProxiedTimerTask
    extends ProxiedTimerTask {
        int activeThreads = 0;

        LongRunningProxiedTimerTask(HMCTimerTask task) {
            super(task);
        }

        public void run() {
            if (this.activeThreads == 0 || this.task.useMultipleThreads()) {
                ++this.activeThreads;
                new Thread(this, "HMC-Timer LongRun service thread for: " + this.task){
                    private final /* synthetic */ LongRunningProxiedTimerTask this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Trace.trace("XH-TIMEF", HMCTimer.access$200(LongRunningProxiedTimerTask.access$100(this.this$1)) + " LongRun service thread (" + this.this$1.task + ") starts");
                        try {
                            this.this$1.task.run();
                        }
                        finally {
                            --this.this$1.activeThreads;
                        }
                    }
                }.start();
            } else {
                Trace.trace(HMCTimer.TRACE_MASKF, HMCTimer.this.name + " ignores timer pop. A thread exists and it's not multi-thread enabled (" + this.task + ")");
            }
        }

        static /* synthetic */ HMCTimer access$100(LongRunningProxiedTimerTask x0) {
            return x0.HMCTimer.this;
        }
    }

    abstract class ProxiedTimerTask {
        protected HMCTimerTask task;
        protected long nextExecutionTime;
        protected long period = 0L;
        protected boolean canceled = false;
        protected boolean fixedDelay = true;

        ProxiedTimerTask(HMCTimerTask task) {
            task.setProxy(this);
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            this.canceled = true;
            HMCTaskQueue hMCTaskQueue = HMCTimer.this.queue;
            synchronized (hMCTaskQueue) {
                HMCTimer.this.queue.notifyAll();
            }
        }

        public abstract void run();

        long reschedule(long currentTime) {
            if (this.fixedDelay) {
                return currentTime + this.period;
            }
            return this.nextExecutionTime + this.period;
        }

        void timeChanged(TimeChangedOnConsoleEvent event) {
        }
    }
}

